unit CellPhoneMainUpdated25;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, jpeg, system.math,
  FileCtrl, Menus, Printers, ComCtrls, CPREVAbout,
  CPMouseMeaning, ExtDlgs, VCLTee.TeEngine, VCLTee.TeeProcs, VCLTee.Chart,
  VCLTee.TeeEdit, system.Generics.Collections,VCLTee.Series,VCL.Imaging.pngimage,
  system.AnsiStrings, PtInfoUnit;

Const
  PixelMax = 8192; {compromise.  32768 hogs too much memory.  Suspect
    this may cause errors for large JPGs} //  11/16/25 increased from 4096 to 8192
  SpecArrayLength = 4096;
  pi = 3.14159265358979;
  ppiref = 96;

type
  TSpecImData = (sample, reference) ;
  pPixelArray = ^TPixelArray;
  TPixelArray = Array[0..PixelMax-1] Of TRGBQuad;
  PSpectrum = ^TSpectrum;
  Twavdom = (samplespec, referencespec, either);
  TOrient = (lineup, linedown, lineleft, lineright, linexdominant, lineydominant,
             areahoriz, areavert, xdominant, ydominant);
  TSpectrum = record
     MinLambda, MaxLambda : real;
     xminpixel, yminpixel, xmaxpixel, ymaxpixel, pixheight, numlambda : integer;
     extorient : torient;
     Wavelength : array [0..SpecArrayLength] of real;
     SpecInputs : array [0..6] of ^TEdit;
     Filename : string;
     Speccurrent : boolean;
     redintense,greenintense,blueintense,totalintense : array of double; // maybe change to integer or cardinal?
     procedure RawToSpec2(UnmarkedPicture: Tbitmap; whichone : TSpecImdata); // probably get rid of whichone as
       // that will be handled by the calling routine identifying the desired spectrum.
    end;
  TTA = record
    Minlambda, Maxlambda : real;
    numlambda : integer;
    wavelength : array [0..SpecArrayLength] of double;
    trans : array [0..SpecArrayLength] of double;
    abs : array [0..SpecArrayLength] of double;
   end;
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    DriveComboBox2: TDriveComboBox;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    Button1: TButton;
    About1: TMenuItem;
    Print1: TMenuItem;
    PrintSetup1: TMenuItem;
    LoadSampleLeft1: TMenuItem;
    LoadReferenceRight1: TMenuItem;
    Label1: TLabel;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PrintDialog1: TPrintDialog;
    N1: TMenuItem;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    Image1: TImage;
    ScrollBox1: TScrollBox;
    DirectoryListBox2: TDirectoryListBox;
    FileListBox2: TFileListBox;
    ScrollBox2: TScrollBox;
    Image2: TImage;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Label8: TLabel;
    Edit7: TEdit;
    UpDown1: TUpDown;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Edit11: TEdit;
    Edit12: TEdit;
    Edit13: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    N2: TMenuItem;
    CSVFileExport1: TMenuItem;
    N3: TMenuItem;
    Button2: TButton;
    SaveTextFileDialog1: TSaveTextFileDialog;
    Chart1: TChart;
    ChartEditor1: TChartEditor;
    Button3: TButton;
    Button4: TButton;
    Label21: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Label22: TLabel;
    TrackBar1: TTrackBar;
    Label23: TLabel;
    Edit14: TEdit;
    procedure About1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure LoadSampleLeft1Click(Sender: TObject);
    procedure LoadReferenceRight1Click(Sender: TObject);
    procedure FileListBox1DblClick(Sender: TObject);
    procedure FileListBox2DblClick(Sender: TObject);
    procedure DirectoryListBox1DblClick(Sender: TObject);
    procedure DirectoryListBox2DblClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit4Exit(Sender: TObject);
    procedure Edit8Exit(Sender: TObject);
    procedure Edit11Exit(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
    procedure Edit5Exit(Sender: TObject);
    procedure Edit6Exit(Sender: TObject);
    procedure Edit7Exit(Sender: TObject);
    procedure Edit9Exit(Sender: TObject);
    procedure Edit10Exit(Sender: TObject);
    procedure Edit12Exit(Sender: TObject);
    procedure Edit13Exit(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure UpDown1ChangingEx(Sender: TObject; var AllowChange: Boolean;
      NewValue: Smallint; Direction: TUpDownDirection);
    procedure Button3MouseEnter(Sender: TObject);
    procedure Button3MouseLeave(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseEnter(Sender: TObject);
    procedure Image1MouseLeave(Sender: TObject);
  private
    { Private declarations }
    ScratchPicture1: Tbitmap;
    ScratchPicture2: Tbitmap;
    Pic1Loaded, Pic2Loaded : boolean;
    SampleSpectrum, ReferenceSpectrum : TSpectrum;
    RatioSpec: TTA;
    CPSFormatSettings : TFormatSettings;
    MyFileNameCache : string;
    dataopendialog1 : topenpicturedialog;
    memxy : tpoint;
    procedure FormAnImage(whichone: TSpecImData);
    procedure ImageMouseClick(ActiveImage : TImage; SpectralData : PSpectrum; whichone : TSpecImData) ;
    procedure SpecAlignReconcile(whichone : TSpecImData);
    function ValIntRange(Sender: TObject; itarget, imin, imax : integer) : Boolean;
    function ValFloatRange(Sender: TObject; rtarget, rmin, rmax : real) : Boolean;
    procedure DrawSpecGuide(UnMarkedPicture : Tbitmap; DestIm : TImage; SpectralData : PSpectrum);
//    procedure RawToSpec(UnmarkedPicture: Tbitmap; SpectralData : PSpectrum; whichone : TSpecImdata);
    procedure MakeTandA;
    function Pythag(ax, ay, bx, by : integer) : real;
  public
    { Public declarations }
    screencount : integer;
    checkboxlist : array[0..2] of ^tcheckbox;
    procedure Openfile(const filename:String; Whichone: TSpecImData);
  end;

  {1024 by 768 was original design layout. Going to 1200 by 650 for Colin Borratt Maloney
   11/25, moving to arbitrary size}
var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);

var
  ii : integer;

begin
  screencount := screen.MonitorCount;
//  OpenDialog1.Filter := GraphicFilter(TGraphic);
  if not assigned(dataopendialog1) then
    dataopendialog1 := topenpicturedialog.Create(form1);
  // assume only jpg enabled at start
//  application.hintpause := 10;
  dataopendialog1.Filter := 'JPG files (*.jpg)|*.JPG;*.jpg';
  FileListbox1.Mask :=  dataopendialog1.filter; // GraphicFileMask(TGraphic);
  FileListbox2.Mask :=  dataopendialog1.filter; // GraphicFileMask(TGraphic);
  Scratchpicture1:=Tbitmap.create;
  Scratchpicture2:=Tbitmap.create;
  Pic1Loaded := false;
  Pic2Loaded := false;
  radiogroup1.visible := false;
  radiogroup2.visible := false;
  button1.visible := false;
  button2.visible := false;
  label22.visible := true;
  SampleSpectrum.SpecInputs[0] := @Edit1;    {blue wavelength}
  SampleSpectrum.SpecInputs[1] := @Edit4;    {red wavelength}
  SampleSpectrum.SpecInputs[2] := @Edit2;    {blue x}
  SampleSpectrum.SpecInputs[3] := @Edit3;    {blue y}
  SampleSpectrum.SpecInputs[4] := @Edit5;    {red x}
  SampleSpectrum.SpecInputs[5] := @Edit6;    {red y}
  SampleSpectrum.SpecInputs[6] := @Edit7;    {height in pixels}
  GetLocaleFormatSettings(LOCALE_SYSTEM_DEFAULT,CPSFormatSettings);
  Myfilenamecache := 'TabDelimitedCPSData.txt';
  SampleSpectrum.MinLambda := STRtoFloat('400',CPSFormatSettings);
  Edit1.text := FloattoSTRF(400.0,fffixed, 4,1,CPSFormatSettings);
  SampleSpectrum.MaxLambda := STRtoFloat('720',CPSFormatSettings);
  Edit4.text := FloattoSTRF(720.0,fffixed, 4,1,CPSFormatSettings);
  SampleSpectrum.xminpixel := 0;
  SampleSpectrum.xmaxpixel := 0;
  SampleSpectrum.yminpixel := 0;
  SampleSpectrum.ymaxpixel := 0;
  SampleSpectrum.pixheight := 1;
  SampleSpectrum.Speccurrent := false;
  ReferenceSpectrum.SpecInputs[0] := @Edit8;    {blue wavelength}
  ReferenceSpectrum.SpecInputs[1] := @Edit11;   {red wavelength}
  ReferenceSpectrum.SpecInputs[2] := @Edit9;    {blue x}
  ReferenceSpectrum.SpecInputs[3] := @Edit10;   {blue y}
  ReferenceSpectrum.SpecInputs[4] := @Edit12;   {red x}
  ReferenceSpectrum.SpecInputs[5] := @Edit13;   {red y}
  ReferenceSpectrum.SpecInputs[6] := @Edit7;    {height in pixels}
  ReferenceSpectrum.MinLambda := STRtoFloat('400',CPSFormatSettings);
  Edit8.text := FloattoSTRF(400.0,fffixed, 4,1,CPSFormatSettings);
  ReferenceSpectrum.MaxLambda := STRtoFloat('720',CPSFormatSettings);
  Edit11.text := FloattoSTRF(720.0,fffixed, 4,1,CPSFormatSettings);
  ReferenceSpectrum.xminpixel := 0;
  ReferenceSpectrum.xmaxpixel := 0;
  ReferenceSpectrum.yminpixel := 0;
  ReferenceSpectrum.ymaxpixel := 0;
  ReferenceSpectrum.pixheight := 1;
  ReferenceSpectrum.Speccurrent := false;
  button1.Enabled := false;
  button2.Enabled := false;
  checkboxlist[0] := @checkbox1;
  checkboxlist[1] := @checkbox2;
  checkboxlist[2] := @checkbox3;
  for ii := 0 to 7 do
     begin
       chart1.addseries(tfastlineseries);
       chart1.series[ii].marks.Visible := false;
     end;
  chart1.series[0].color := clred;
  chart1.series[1].color := clgreen;
  chart1.series[2].color := clblue;
  chart1.series[3].color := clblack;
  chart1.series[4].color := clmaroon;
  chart1.series[5].color := cllime;
  chart1.series[6].color := claqua;
  chart1.series[7].color := clpurple;
  for ii := 0 to 3 do
     chart1.series[ii+4].pen.Width := 3*chart1.series[ii].pen.width;
  for ii := 0 to 7 do
     begin
       chart1.series[ii].pen.color := chart1.series[ii].color;
     end;
  trackbar1change(self);
end;

procedure TForm1.FormResize(Sender: TObject);

var
  paintwidth, paintheight, ii, ppilocal, tempwidth, repnum : integer;
  tempbitmap : tbitmap;

begin
  paintwidth := form1.Width - form1.BorderWidth*2 - form1.vertscrollbar.size;
  paintheight := form1.height - form1.borderwidth*2 - form1.HorzScrollBar.size;
  ppilocal := form1.monitor.PixelsPerInch;
  scrollbox1.top := 0;
  scrollbox1.left := 0;
  drivecombobox1.top := 0;
  drivecombobox1.width := paintwidth div 6;
  drivecombobox1.left := (paintwidth - drivecombobox1.width) div 2-(6*ppilocal div ppiref);
  directorylistbox1.width := drivecombobox1.width;
  directorylistbox1.left := drivecombobox1.left;
  directorylistbox1.top := drivecombobox1.top + drivecombobox1.height + 1;
  filelistbox1.width := directorylistbox1.width;
  filelistbox1.left := directorylistbox1.left;
  filelistbox1.top := directorylistbox1.top + directorylistbox1.height + 1;
  filelistbox1.height := directorylistbox1.height; // may need to program height as f(screen size)
  label3.width := directorylistbox1.width + 2*17*ppilocal div ppiref;
  label3.top := filelistbox1.top + filelistbox1.height + 2;
  tempbitmap := tbitmap.create;
  try
    tempbitmap.Canvas.Font.Assign(label3.Font);
    tempwidth := tempbitmap.Canvas.TextWidth('_');
    repnum := label3.width div tempwidth;
  finally
    tempbitmap.destroy;
  end;
  label3.Caption := ''; // truncates to 0 characters
  for ii := 0 to max(1,repnum-1) do
     label3.caption := label3.caption + '_';
  label3.left := (paintwidth - label3.width) div 2;
  label1.top := directorylistbox1.top;
  label1.left := (drivecombobox1.left - label1.width) - 14 * ppilocal div ppiref;
  label5.caption := '';
  tempbitmap := tbitmap.create;
  try
    tempbitmap.Canvas.Font.Assign(label5.Font);
    tempwidth := tempbitmap.Canvas.Textheight('|');
    repnum := (directorylistbox1.height + filelistbox1.height + drivecombobox1.height) div tempwidth;
  finally
    tempbitmap.destroy;
  end;
  for ii := 0 to max(1,repnum) do
     label5.caption := label5.caption + '| ';
  label5.left := drivecombobox1.left + drivecombobox1.width + 6 * ppilocal div ppiref; // need to work on height of both label 1 and 5
  drivecombobox2.top := label3.top + (label3.height * 15 div 10);
  drivecombobox2.width := drivecombobox1.width;
  drivecombobox2.left := drivecombobox1.left;
  directorylistbox2.width := directorylistbox1.width;
  directorylistbox2.left := directorylistbox1.left;
  directorylistbox2.top := drivecombobox2.top + drivecombobox2.height + 1;
  filelistbox2.width := filelistbox1.width;
  filelistbox2.height := filelistbox1.height;
  filelistbox2.left := filelistbox1.left;
  filelistbox2.top := directorylistbox2.top + directorylistbox2.height + 1;
  label4.caption := label5.caption;
  label4.left := label3.left;
  label4.top := label3.top+ label3.height * 3 div 2;
  scrollbox1.top := 0;
  scrollbox1.left := 5;
  scrollbox1.width := label1.left-5;
  scrollbox1.height := max(300,form1.height*2 div 5); // improve later
  label2.top := directorylistbox2.top;
  label2.left := directorylistbox2.left + directorylistbox2.width + 6 * ppilocal div ppiref;
  scrollbox2.top := 0;
  scrollbox2.left := label2.left + label2.width + 2;
  scrollbox2.width := scrollbox1.width;
  scrollbox2.height := scrollbox1.height;
  radiogroup1.top := scrollbox1.top + scrollbox1.height + (6 * ppilocal div ppiref);
  radiogroup2.top := radiogroup1.top + radiogroup1.height + (6 * ppilocal div ppiref);
  radiogroup1.left := 8 * ppilocal div ppiref;
  radiogroup2.left := radiogroup1.left;
  label22.top := radiogroup2.top;
  label22.left := radiogroup2.left;
  button1.top := radiogroup2.top + radiogroup2.height + (8 * ppilocal div ppiref);
  button2.top := button1.top + button1.height + (8 * ppilocal div ppiref);
  button1.left := radiogroup1.left + ((radiogroup1.width - button1.width) div 2);
  button2.left := button1.left;
  button3.top := button2.top + button2.height + (8 * ppilocal div ppiref);
  button3.left := button2.left;
  chart1.top := max(max(filelistbox2.top + filelistbox2.height, label2.top + label2.height) + (8 * ppilocal div ppiref),scrollbox1.top + scrollbox1.height);
  chart1.left := radiogroup1.left + radiogroup1.width + (8 * ppilocal div ppiref);
  chart1.width := label2.left + label2.width - chart1.left;
  chart1.height := form1.clientheight - chart1.top;
  button4.top := radiogroup2.top + radiogroup2.height;
  button4.left := chart1.left + chart1.width + (8*ppilocal div ppiref);
  label21.top := button4.top + 3*button4.height;
  label21.left :=  button4.left;
  for ii := 0 to 2 do
     begin
       checkboxlist[ii].top := label21.top + label21.height + ii * (checkbox1.Height+(4*ppilocal div ppiref));
       checkboxlist[ii].left := label21.left + (10*ppilocal div ppiref);
     end;
  label6.top := scrollbox2.top + scrollbox2.height + label6.height;
  label6.left := max(label21.left + label21.width + (4*ppilocal div ppiref),(2*scrollbox2.left + scrollbox2.width-label6.width) div 2);
  edit1.left := (2*label6.left + label6.width - (edit1.width + edit2.width + edit3.width + (12*ppilocal div ppiref))) div 2;
  edit2.left := edit1.left + edit1.width + (6*ppilocal div ppiref);
  edit3.left := edit2.left + edit2.width + (6*ppilocal div ppiref);
  edit1.top := label6.top + label6.height + (4*ppilocal div ppiref);
  edit2.top := edit1.top;
  edit3.top := edit1.top;
  label9.top := edit1.top + edit1.height + (4*ppilocal div ppiref);
  label9.left := edit1.left;
  label11.top := label9.top;
  label11.left := edit2.left;
  label12.top := label9.top;
  label12.left := edit3.left;
  edit4.Top := label9.top + label9.height + (4*ppilocal div ppiref);
  edit4.Left := edit1.left;
  edit5.Top := edit4.top;
  edit5.Left := edit2.left;
  edit6.Top := edit4.top;
  edit6.left := edit3.left;
  label10.top := edit4.top + edit4.height + (4*ppilocal div ppiref);
  label10.left := edit4.left;
  label13.top := label10.top;
  label13.left := edit5.left;
  label14.top := label10.top;
  label14.left := edit6.left;
  edit8.top := label10.top + label10.height*5;
  edit9.top := edit8.top;
  edit10.top := edit8.top;
  edit8.left := max(edit1.left,label21.left + label21.width+(10*ppilocal div ppiref));
  edit9.left := edit8.left + edit8.width + (4*ppilocal div ppiref);
  edit10.left := edit9.left + edit9.width + (4*ppilocal div ppiref);
  label7.top := edit8.top-label7.height - (4*ppilocal div ppiref);
  label7.left := (edit8.left + edit10.left + edit10.width - label7.width) div 2;
  label15.Top := edit8.top + edit8.height + (4*ppilocal div ppiref);
  label15.Left := edit8.left;
  label16.top := label15.top;
  label16.Left := edit9.left;
  label17.top := label15.top;
  label17.left := edit10.left;
  edit11.top := label15.top + label15.height + (4*ppilocal div ppiref);
  edit11.left := edit8.left;
  edit12.top := edit11.top;
  edit12.left := edit9.left;
  edit13.top := edit11.top;
  edit13.left := edit10.left;
  label18.top := edit11.top + edit11.height + (4*ppilocal div ppiref);
  label18.left := edit11.left;
  label19.top := label18.top;
  label19.left := edit12.left;
  label20.top := label18.top;
  label20.left := edit13.left;
  label8.top := max(label21.top,label18.top + label18.height + (4*ppilocal div ppiref));
  label8.left := (2*label7.left + label7.width - label8.width) div 2;
  edit7.top := label8.top + label8.height + (4*ppilocal div ppiref);
  edit7.left := label8.left;
  updown1.top := edit7.top;
  updown1.left := edit7.left + edit7.width + 2;
  trackbar1.left := edit7.left;
  trackbar1.top := edit7.top + 3*checkbox3.Height;
  label23.top := trackbar1.top-label23.height;
  label23.left := trackbar1.left + (trackbar1.width div 2) - (label23.width div 2);
  edit14.Top := trackbar1.top;
  edit14.left := trackbar1.left + trackbar1.width;
end;

function TForm1.pythag(ax, ay, bx, by : integer) : real;

var
  scratchreal : real;

begin
  scratchreal := (ax-bx)*(ax-bx) + (ay-by)*(ay-by);
  pythag := sqrt(scratchreal);
end;

procedure TForm1.Image1Click(Sender: TObject);
begin
  {Code for selecting wavelengths and x,y pairs}
  ImageMouseClick(Image1, @samplespectrum, sample);
end;

procedure TForm1.Image1MouseEnter(Sender: TObject);
begin
  if sender = image1 then
    begin
      ptinfo.Left := form1.left + scrollbox1.left + scrollbox1.width div 10;
      ptinfo.top := form1.top + scrollbox1.top + scrollbox1.height + ptinfo.height div 2;
    end
  else
    if sender = image2 then
    begin
      ptinfo.Left := form1.left + scrollbox2.left + scrollbox2.width div 10;
      ptinfo.top := form1.top + scrollbox2.top + scrollbox2.height + ptinfo.height div 2;
    end
  else
    showmessage('Sender was not an image.');
  ptinfo.show;
end;

procedure TForm1.Image1MouseLeave(Sender: TObject);
begin
 ptinfo.hide;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);

var
  localscanline : ppixelarray;

begin
 // save x,y
 if (x<>memxy.x) or (y<>memxy.y) then
   begin
     memxy.x := x;
     memxy.y := y;
     localscanline := timage(sender).Picture.bitmap.ScanLine[y];
     ptinfo.edit1.text := inttostr(x);
     ptinfo.edit2.text := inttostr(y);
     ptinfo.edit3.text := inttostr(localscanline[x].rgbRed);
     ptinfo.edit4.text := inttostr(localscanline[x].rgbGreen);
     ptinfo.edit5.text := inttostr(localscanline[x].rgbBlue);
   end;
end;

procedure TForm1.Image2Click(Sender: TObject);
begin
  {Code for selecting wavelengths and x,y pairs}
  ImageMouseClick(Image2, @referencespectrum, reference);
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  Form2.show;
end;

procedure tspectrum.RawToSpec2(UnmarkedPicture: TBitmap; whichone: TSpecImData);

const anglimit = 0.001;

var
   cosRadians : Double;
   inX : Integer;
   inXOriginal : Integer;
   inXPrime : Integer;
   inXPrimeRotated : Integer;
   inY : Integer;
   inYOriginal : Integer;
   inYPrime : Integer;
   inYPrimeRotated : Integer;
   OriginalRow : pPixelArray;
   Radians : Double;
   sinRadians : Double;
   tanradians : double;
   localslope : double;
   Center, xspan : TPoint;
   rowmin, Rowmax, colmin, colmax, intercept : integer;
//   sizescratch : integer;
   testcolor1 : trgbpixel;
//   testcolor2 : trgbquad;
   boxcorners : array[0..3] of tpoint;
   boxslope, recipboxslope : array[0..3] of double;
   isntpf32 : boolean;

procedure findboxcorners;

var
//  perpenradians : double;
  topincr, botincr, ii, jj : integer;

procedure swapcorners(swap1, swap2 : integer);

var
  scratchpoint : tpoint;

begin
  scratchpoint.x := boxcorners[swap2].x;
  scratchpoint.y := boxcorners[swap2].y;
  boxcorners[swap2].x := boxcorners[swap1].x;
  boxcorners[swap2].y := boxcorners[swap1].y;
  boxcorners[swap1].x := scratchpoint.x;
  boxcorners[swap1].y := scratchpoint.y;
end;

begin
{  perpenradians := radians + pi / 2;
  if perpenradians>2*pi then
    perpenradians := perpenradians - 2*pi;  }
  topincr := form1.UpDown1.Position div 2;
  botincr := topincr;
  if topincr + botincr + 1<form1.UpDown1.position then
    inc(topincr);
      boxcorners[0].x := center.x-round(topincr*sinradians);
      boxcorners[0].y := center.y-round(topincr*cosradians);
      boxcorners[1].x := round(xmaxpixel-topincr*sinradians);
      boxcorners[1].y := round(ymaxpixel-topincr*cosradians);
      boxcorners[2].x := round(xmaxpixel+botincr*sinradians);
      boxcorners[2].y := round(ymaxpixel+botincr*cosradians);
      boxcorners[3].x := center.x+round(botincr*sinradians);
      boxcorners[3].y := center.y+round(botincr*cosradians);
      // check that corners are now correct for small + angle, small - angle, and near 90
  rowmin := unmarkedpicture.Height;
  rowmax := 0;
  colmin := unmarkedpicture.Width;
  colmax := 0;
  for ii := 0 to 3 do
     begin
       if boxcorners[ii].x>colmax then colmax := boxcorners[ii].x;
       if boxcorners[ii].x<colmin then colmin := boxcorners[ii].x;
       if boxcorners[ii].y>rowmax then rowmax := boxcorners[ii].y;
       if boxcorners[ii].y<rowmin then rowmin := boxcorners[ii].y;
     end;
  // now sort so, regardless of rotation, segments are top, left middle, right middle, bottom
  // or top left, top right, bottom left, bottom right
  // note middle left may be either above or below right middle, but bubble sort puts upper-most y
  // point highest in initial pass
  for ii := 0 to 2 do  // float top y's to top, ignoring x
     begin
       for jj := 0 to 2 do
          begin
            if boxcorners[jj].y>boxcorners[jj+1].y then  // fixed 12/29/25
              begin
                swapcorners(jj,jj+1);
              end;
          end;
     end;
  // now get left/right correct since every y is <= subsequent y
  if boxcorners[0].y=boxcorners[1].y then    // parallel to x axis
    begin
      if boxcorners[0].x>boxcorners[1].x then
        begin
          swapcorners(0,1);
        end;
      if boxcorners[2].x>boxcorners[3].x then
          swapcorners(2,3);
      // works for parallel to either axis. Delta x will be small for vertical, large for horizontal
    end
  else
    begin  // not parallel to x axis
      // top and bottom are already correct. Need leftmost first for intermediate points
      if boxcorners[1].x>boxcorners[2].x then
        swapcorners(1,2);
      boxslope[0] := (boxcorners[0].y - boxcorners[1].y)/(boxcorners[1].x - boxcorners[0].x);
      boxslope[1] := (boxcorners[1].y - boxcorners[3].y)/(boxcorners[3].x - boxcorners[1].x);
      boxslope[2] := (boxcorners[0].y - boxcorners[2].y)/(boxcorners[2].x - boxcorners[0].x);
      boxslope[3] := (boxcorners[2].y - boxcorners[3].y)/(boxcorners[3].x - boxcorners[2].x);
      for ii := 0 to 3 do
         if abs(boxslope[ii])>1E-6 then
           recipboxslope[ii] := 1/boxslope[ii]
         else
           recipboxslope[ii] := 1E31; // nearly infinite but not overflow
    end;
end;

function findxminmaxydom(yval : integer) : tpoint;   // output x value as left end, y value as right end

var
  ii : integer;

begin
  // check that call isn't fouled up
  if (boxcorners[0].y = boxcorners[1].y) then
    showmessage('This is a pure rectangle, aligned with an axis. Program bug!')
  else
    begin
      result.x := 0;
      result.y := 0; // if failure, 0,0 is the result
      ii := yval - boxcorners[0].y; // gives distance from reference and sign. Should always be positive or 0.
      if ii=0 then
        begin
          result.x := boxcorners[0].x;
          result.y := boxcorners[0].x;
        end
      else if ii<0 then
        begin
          showmessage('ii = '+inttostr(ii)+', which should never happen.');
        end
      else
        begin
          // no need for original logic. [1] is left-most, [2] is right-most
          // find left limit
          if yval<boxcorners[1].y then
            begin
              result.x := boxcorners[1].x + round((boxcorners[1].y - yval)*recipboxslope[0]);
            end
          else
            begin
              result.x := boxcorners[3].x + round((boxcorners[3].y - yval)*recipboxslope[1]);
            end;
          // find right limit
          if yval<boxcorners[2].y then
            begin
              result.y := boxcorners[2].x + round((boxcorners[2].y - yval)*recipboxslope[2]);
            end
          else
            begin
              result.y := boxcorners[3].x + round((boxcorners[3].y - yval)*recipboxslope[3])
            end;
        end;
    end;
end;

function findxminmaxxdom(yval : integer) : tpoint;

// loop through all x's that fall between row's y - 0.5 to row's y + 0.5
var
  ii : integer;
  softyplus, softyminus : real;
  softxleft, softxright, softxcenter : array[0..1] of real;

begin
      result.x := 0;
      result.y := 0; // if failure, 0,0 is the result
      ii := yval - boxcorners[0].y; // gives distance from reference and sign. Should always be positive or 0.
      if ii=0 then
        begin
          result.x := boxcorners[0].x;
          result.y := boxcorners[0].x;
        end
      else if ii<0 then
        begin
          showmessage('ii = '+inttostr(ii)+', which should never happen.');
        end
      else if yval = boxcorners[3].y then
        begin
          result.x := boxcorners[3].x;
          result.y := boxcorners[3].x;
        end
      else
        begin
          if (yval = boxcorners[0].y+1) then  // find x's for y = boxcorners[0].y+0.2 to boxcorners[0].y+1.49
            begin
             softyminus := boxcorners[0].y+0.2;
             softyplus := boxcorners[0].y+1.49;
            end
          else if (yval = boxcorners[3].y-1) then // find x's for y = boxcorners[3]-1.5 to boxcorners[3].y-0.2
            begin
             softyminus := boxcorners[3].y-1.5;
             softyplus := boxcorners[3].y-0.49;
            end
          else   // find x's for y = yval-0.5 to y = yval+0.49
            begin
              softyminus := yval-0.5;
              softyplus := yval+0.49;
            end;
          // find x range
          // first left, then right of above, below. x is MAX of this range, except not off-image.
          if softyminus<boxcorners[1].y then
            softxleft[0] := boxcorners[1].x + round((boxcorners[1].y-softyminus)*recipboxslope[0])
          else
            softxleft[0] := boxcorners[3].x + round((boxcorners[3].y-softyminus)*recipboxslope[1]);
          if softyplus<boxcorners[1].y then
            softxleft[1] := boxcorners[1].x + round((boxcorners[1].y-softyplus)*recipboxslope[0])
          else
            softxleft[1] := boxcorners[3].x + round((boxcorners[3].y-softyplus)*recipboxslope[1]);
          if softyminus<boxcorners[2].y then
            softxright[0] := boxcorners[2].x + round((boxcorners[2].y-softyminus)*recipboxslope[2])
          else
            softxright[0] := boxcorners[3].x + round((boxcorners[3].y-softyminus)*recipboxslope[3]);
          if softyplus<boxcorners[2].y then
            softxright[1] := boxcorners[2].x + round((boxcorners[2].y-softyplus)*recipboxslope[2])
          else
            softxright[1] := boxcorners[3].x + round((boxcorners[3].y-softyplus)*recipboxslope[3]);
          if yval<boxcorners[1].y then
            softxcenter[0] := boxcorners[1].x + round((boxcorners[1].y - yval)*recipboxslope[0])
          else
            softxcenter[0] := boxcorners[3].x + round((boxcorners[3].y - yval)*recipboxslope[1]);
          if yval<boxcorners[2].y then
            softxcenter[1] := boxcorners[2].x + round((boxcorners[2].y - yval)*recipboxslope[2])
          else
            softxcenter[1] := boxcorners[3].x + round((boxcorners[3].y - yval)*recipboxslope[3]);
          // combine info to get result
          result.x := max(0,round(min(softxright[0],min(softxright[1],softxcenter[0]))));
          result.y := min(unmarkedpicture.width-1,round(max(softxleft[0],max(softxleft[1],softxcenter[1]))));
        end;
end;

{function plug3(incolor : trgbpixel) : trgbquad;

begin
  result.rgbRed := incolor.r;
  result.rgbGreen := incolor.g;
  result.rgbBlue := incolor.b;
end;       }

procedure pointxfer(specpos, rowpos : integer);

begin
  redintense[specpos] := redintense[specpos] + originalrow[rowpos].rgbRed;
  greenintense[specpos] := greenintense[specpos] + originalrow[rowpos].rgbGreen;
  blueintense[specpos] := blueintense[specpos] + originalrow[rowpos].rgbBlue;
end;

begin
  // need to define angle as tilt of red end w.r.t. blue end, which is anchor point
  // need to check elsewhere that y and x max and min are appropriately defined
  // set pivot point
  center.x := xminpixel;
  center.y := yminpixel;
  Radians := arctan2(yminpixel-ymaxpixel,xmaxpixel-xminpixel);
  if radians<0 then
    radians := radians + 2*pi; // forces angle to be between 0 and 2 pi
  numlambda := round(sqrt((xmaxpixel-xminpixel)*(xmaxpixel-xminpixel)+(ymaxpixel-yminpixel)*(ymaxpixel-yminpixel))) + 1;
// Using + signs computes the cos and sin of the original angles. We want to rotate in the opposite direction.
  cosradians := cos(radians);
  sinradians := sin(radians);
  if abs(cosradians)>1E-5 then
    tanradians := tan(radians)
  else
    if sign(sinradians)<>sign(cosradians) then
      tanradians := -1E200
    else
      tanradians := 1E200; // just to prevent infinity.
  if form1.UpDown1.Position=1 then
    begin
      if (abs(radians)<anglimit) or (abs(radians-pi)<anglimit) then
        begin
          if xmaxpixel>xminpixel then
            extorient := lineright
          else
            extorient := lineleft;
        end
      else if (abs(radians-pi/2)<anglimit) or (abs(radians - 3*pi/2)<anglimit) then
          begin
            if yminpixel>ymaxpixel then
              extorient := lineup // note sign convention!
            else
              extorient := linedown;
          end
      else
          begin
            if (0<= radians) and (radians < pi/4) or
              (3*pi/4<= radians) and (radians < 5*pi/4) or
              (7*pi/4<= radians) then
              extorient := linexdominant
            else
              extorient := lineydominant;
          end;
     end
  else   // area extraction
    begin
      findboxcorners;
      if boxcorners[0].y = boxcorners[1].y then  // axis-aligned
        begin
          if xminpixel = xmaxpixel then
            begin
              extorient := areavert
            end
          else if yminpixel = ymaxpixel then
            begin
              extorient := areahoriz;
            end
          else
            begin
              showmessage('Is the box a point?');
            end;
        end
      else
        begin
          if (0<= radians) and (radians < pi/4) or
            (3*pi/4<= radians) and (radians < 5*pi/4) or
            (7*pi/4<= radians) then
            extorient := xdominant
          else
            extorient := ydominant;
        end;
    end;
  if unmarkedpicture.PixelFormat = pf32bit then
    isntpf32 := false else isntpf32 := true;
  // clear spectrum
  setlength(redintense,0);
  setlength(greenintense,0);
  setlength(blueintense,0);
  setlength(totalintense,0);
  // set spectrum length and numlambda
  setlength(redintense,numlambda);
  setlength(greenintense,numlambda);
  setlength(blueintense,numlambda);
  setlength(totalintense,numlambda);
  // min and max pixels are for centerline, not full extraction box
  case extorient of
    lineup, linedown: begin
      for iny := min(yminpixel,ymaxpixel) to max(yminpixel,ymaxpixel) do
         begin
           originalrow := unmarkedpicture.ScanLine[iny];
           inxoriginal := abs(iny - center.y);
           inx := center.x;
           pointxfer(inxoriginal,inx);
         end;
    end;
    lineleft, lineright: begin
      originalrow := unmarkedpicture.scanline[center.y];
      for inxprime := min(xminpixel,xmaxpixel) to max(xminpixel,xmaxpixel) do
         begin
           inx := inxprime;
           inxoriginal := abs(inx - center.x);
           pointxfer(inxoriginal, inxprime);
         end;
    end;
    linexdominant: begin
       for inx := min(xminpixel,xmaxpixel) to max(xminpixel, xmaxpixel) do
          begin
            iny := round(center.y - tanradians*(inx - center.x));  // test if sign is right
            originalrow := unmarkedpicture.ScanLine[iny];
            inxoriginal :=  min(max(0,round(cosradians*(inx-center.x)-sinradians*(iny - center.y))),numlambda);
            pointxfer(inxoriginal, inx);
          end;
    end;
    lineydominant: begin
       for iny := min(yminpixel,ymaxpixel) to max(yminpixel,ymaxpixel) do
         begin
           originalrow := unmarkedpicture.ScanLine[iny];
           inx := round(center.x + (center.y - iny)/tanradians);
           inxoriginal := min(max(0,round(cosradians*(inx - center.x)-sinradians*(iny - center.y))),numlambda);
           pointxfer(inxoriginal,inx);
         end;
    end;
    areahoriz: begin // 2D aligned with x axis
       for iny := min(boxcorners[0].y,boxcorners[2].y) to max(boxcorners[0].y,boxcorners[2].y) do
          begin
            originalrow := unmarkedpicture.ScanLine[iny];
            if xminpixel<xmaxpixel then
              begin
                for inx := xminpixel to xmaxpixel do
                   begin
                     inxoriginal := inx-center.x;
                     pointxfer(inxoriginal,inx);
                   end;
              end
            else
              begin
                for inx := xmaxpixel to xminpixel do
                   begin
                     inxoriginal := center.x - inx;
                     pointxfer(inxoriginal,inx);
                   end;
              end;
          end;
    end;
    areavert: begin // 2D aligned with y axis
      for iny := min(yminpixel,ymaxpixel) to max(yminpixel,ymaxpixel) do
        begin
          originalrow := unmarkedpicture.scanline[iny];
          inxoriginal := abs(iny - center.Y);
          for inx := min(boxcorners[0].x,boxcorners[1].x) to max(boxcorners[0].x,boxcorners[1].x) do
            begin
              pointxfer(inxoriginal,inx);
            end;
        end;
    end;
    // from here to end of subroutine, flip sign of sine 1/5/26
    xdominant : begin
      // might be as few as 2 y values but need to process for all x. Finding range of x for each y is the challenge.
      if boxcorners[3].y-boxcorners[0].y<=3 then // so little tilt it's effectively flat
        begin
          for iny := boxcorners[0].y+1 to boxcorners[3].y-1 do
             begin
               originalrow := unmarkedpicture.scanline[iny];
               for inx := boxcorners[1].x to boxcorners[2].x do
                  begin
                    pointxfer(abs(inx - center.x),inx);
                  end;
             end;
        end
      else
        begin
          // loop through all x's that fall between row's y - 0.5 to row's y + 0.5
          for iny := boxcorners[0].y to boxcorners[3].y do
             begin
               originalrow := unmarkedpicture.scanline[iny];
               xspan := findxminmaxxdom(iny);
               if (xspan.x<>0) or (xspan.y>0) then
                 begin
                   for inx := xspan.x to xspan.y do
                      begin
                       // find r(pixel)
                       inxoriginal := round(cosradians*(inx - center.x) + sinradians*(center.y - iny));
                       if inxoriginal<0 then inxoriginal := 0; // prevent underflow
                       // add to spectrum
                       pointxfer(inxoriginal,inx);
                      end;
                 end
               else
                 showmessage('Unexpected x span. y = '+inttostr(iny)+', x values '+inttostr(xspan.x)+', '+inttostr(xspan.y));
             end;
        end;
      end;
    ydominant: begin
       for iny := boxcorners[0].y to boxcorners[3].y do
          begin
            originalrow := unmarkedpicture.scanline[iny];
            // find min and max x pixels in row
            xspan := findxminmaxydom(iny);
            // iterate through pixels
            if (xspan.x<>0) or (xspan.y>0) then
              begin
                for inx := xspan.x to xspan.y do
                   begin
                    // find r(pixel)
                    inxoriginal := round(cosradians*(inx - center.x) + sinradians*(center.y - iny));
                    if inxoriginal<0 then inxoriginal := 0; // prevent underflow
                    // add to spectrum
                    pointxfer(inxoriginal,inx);
                   end;
               end
            else
              showmessage('Unexpected x span. y = '+inttostr(iny)+', x values '+inttostr(xspan.x)+', '+inttostr(xspan.y));
          end;
    end;
  end;
  for inx := 0 to High(redintense) do
     totalintense[inx] := redintense[inx] + greenintense[inx] + blueintense[inx];
end;

{procedure TForm1.RawToSpec(UnmarkedPicture: Tbitmap; SpectralData : PSpectrum; whichone : TSpecImdata);

var
   cosRadians : Double;
   inX : Integer;
   inXOriginal : Integer;
   inXPrime : Integer;
   inXPrimeRotated : Integer;
   inY : Integer;
   inYOriginal : Integer;
   inYPrime : Integer;
   inYPrimeRotated : Integer;
   OriginalRow : pPixelArray;
   Radians : Double;
   RotatedRow : pPixelArray;
   sinRadians : Double;
   Center : TPoint;
   Myangle : double;
   ScratchBitmap1 : TBitmap;
   Rowmax : integer;
   sizescratch : integer;
   testcolor1 : trgbpixel;
   testcolor2 : trgbquad;
begin
  {extract RGB and total intensity; mark that spectrum is current}
  {test bitmap type.  Allow 15, 16, 24, and 32 bit formats only}
  // Since bitmaps are defined as pf24bit, no need to check on the pixel format
{  if UnmarkedPicture.pixelformat = pfDevice then
    begin
      try
        originalrow := unmarkedpicture.ScanLine[1500];
        testcolor1.B := originalrow[1000].rgbtblue;
        testcolor2.rgbblue := originalrow[1000].rgbtblue;
      finally
        showmessage('The two bytes are: '+inttostr(testcolor1.b)+', '+inttostr(testcolor2.rgbBlue));
      end;
    end;
  if (UnmarkedPicture.PixelFormat<>pf24bit) and
     (UnmarkedPicture.PixelFormat<>pf32bit) and
     (UnmarkedPicture.PixelFormat<>pf15bit) and
     (UnmarkedPicture.PixelFormat<>pf16bit) then
     begin
       showmessage('JPG pixel format not 15, 16, 24, or 32 bit.  Can not process data.');
     end
  else
    begin
    {rotate and translate spectrum to edge of scratch bitmap
     to avoid suscript problems, scratch copy of image with dimensions
     2 pixels bigger than opposite corner distance.
    // For really big images, the old algorithm is too slow. Need to copy only the active area.
    Scratchbitmap1 := tbitmap.Create;
    Try
      scratchbitmap1.pixelformat := pf24bit; // unmarkedpicture.pixelformat;
      {rotate about blue end of spectrum
      center.x := Spectraldata.xminpixel;
      center.Y := Spectraldata.yminpixel;
      Myangle := arctan((spectraldata.ymaxpixel-spectraldata.yminpixel)/(spectraldata.xmaxpixel-spectraldata.xminpixel));
      IF Spectraldata.xminpixel<Spectraldata.xmaxpixel then
        begin
          Myangle:=Myangle-pi/2;
        end
      else
        If Spectraldata.xminpixel>Spectraldata.xmaxpixel then
          Myangle := Myangle + pi/2
            else
              If Spectraldata.yminpixel>Spectraldata.ymaxpixel then
                Myangle := pi
                  else Myangle := 0;
      // here's where we can limit the area we extract
      sizescratch := 2 + round(pythag(0,0,UnmarkedPicture.width,UnmarkedPicture.height));
      scratchBitmap1.Width := sizescratch;
      scratchBitmap1.Height := sizescratch;
      scratchBitmap1.PixelFormat := pf24bit;
      sinRadians := Sin(Myangle) ;
      cosRadians := Cos(Myangle) ;
      For inX := scratchbitmap1.Height-1 Downto 0 Do      {for wide raw image, scan gets truncated  used to be unmarkedpicture.
        Begin
          RotatedRow := scratchBitmap1.Scanline[inX];
          inXPrime := 2*(inX - Center.y) + 1;
          For inY := scratchbitmap1.Width-1 Downto 0 Do   {bug must be in here ...
            Begin
               inYPrime := 2*(inY - Center.x) + 1;
               inYPrimeRotated := Round(inYPrime * CosRadians - inXPrime * sinRadians) ;
               inXPrimeRotated := Round(inYPrime * sinRadians + inXPrime * cosRadians) ;
               inYOriginal := (inYPrimeRotated - 1) Div 2 + Center.x;
               inXOriginal := (inXPrimeRotated - 1) Div 2 + Center.y;
               If
                 (inYOriginal >= 0) And
                 (inYOriginal <= UnmarkedPicture.Width-1) And
                 (inXOriginal >= 0) And
                 (inXOriginal <= UnmarkedPicture.Height-1)
               Then
                 Begin
                   OriginalRow := UnmarkedPicture.Scanline[inXOriginal];
                   RotatedRow[inY] := OriginalRow[inYOriginal]
                 End
               else
                 begin
                   RotatedRow[inY].rgbtBlue := 0;
                   RotatedRow[inY].rgbtGreen := 0;
                   RotatedRow[inY].rgbtRed := 0
                 end;
            End;
        End;
    {Info is rotated. Minimum row = spectrum.yminpixel
      rowmax := spectraldata.yminpixel + Round(pythag(spectraldata.xminpixel, spectraldata.yminpixel, spectraldata.xmaxpixel, spectraldata.ymaxpixel));
      if Rowmax>scratchbitmap1.height then
        begin
          rowmax := scratchbitmap1.height;
          showmessage('WARNING!! Because of spectrum location in picture, data have been truncated during processing.');
        end;
    {For each row, sum intensities in each RGB channel and assign wavelength
    Inyoriginal := spectraldata.xminpixel-spectraldata.pixheight div 2;
    Inyprime := spectraldata.xminpixel+spectraldata.pixheight div 2;
    if Inyoriginal<0 then Inyoriginal :=0;
    if inyprime>scratchbitmap1.width then inyprime := scratchbitmap1.width;
    for Inx := 0 to Length(spectraldata.wavelength) - 1 do
          spectraldata.wavelength[Inx]:=0;       {added to avoid seeing leftovers from earlier, longer spectra when recomputing
    spectraldata.numlambda := rowmax - spectraldata.yminpixel+1;
    for Inx := spectraldata.yminpixel to rowmax do
      begin
        OriginalRow := scratchbitmap1.Scanline[inX];
        Spectraldata.RedIntense[Inx-spectraldata.yminpixel] := 0;
        Spectraldata.GreenIntense[Inx-spectraldata.yminpixel] := 0;
        Spectraldata.BlueIntense[Inx-spectraldata.yminpixel] := 0;
        Spectraldata.totalintense[Inx-spectraldata.yminpixel] := 0;
        spectraldata.Wavelength[Inx-spectraldata.yminpixel] := spectraldata.MinLambda +
            (spectraldata.MaxLambda-spectraldata.minlambda)*(Inx-spectraldata.yminpixel)/spectraldata.numlambda;
        for Iny := inyoriginal to inyprime do
           begin
              spectraldata.RedIntense[Inx-spectraldata.yminpixel] := spectraldata.RedIntense[Inx-spectraldata.yminpixel]+  Originalrow[iny].rgbtRed;
              spectraldata.GreenIntense[Inx-spectraldata.yminpixel] := spectraldata.GreenIntense[Inx-spectraldata.yminpixel] + Originalrow[iny].rgbtGreen;
              spectraldata.BlueIntense[Inx-spectraldata.yminpixel] := spectraldata.BlueIntense[Inx-spectraldata.yminpixel] + Originalrow[iny].rgbtBlue;
            end;
            spectraldata.totalintense[Inx-spectraldata.yminpixel] := spectraldata.Redintense[Inx-spectraldata.yminpixel]
             + spectraldata.GreenIntense[Inx-spectraldata.yminpixel] + spectraldata.BlueIntense[Inx-spectraldata.yminpixel];
      end;
    Finally
       scratchbitmap1.free;
    End;
//    end;
end;        }

procedure TForm1.MakeTandA;

var
  scratchint1, scratchint2, i, j, k, ifirst, ilast : integer;
  dominantspec : Twavdom ;
  foundblock : Boolean;

begin
{Obsolete comment (6/14/11): Need a different strategy.  Translate I(lambda) into spline and ratio the splines?}
{Obsolete comment (6/14/11): Hunch: overextended plots are due to plotting of previous, longer data.  Maybe empty ratiospec.T and A before each computation?}
    IF samplespectrum.MinLambda>referencespectrum.MinLambda then ratiospec.minlambda := samplespectrum.MinLambda
      else ratiospec.minlambda := referencespectrum.MinLambda;
    IF samplespectrum.maxlambda<referencespectrum.MaxLambda then ratiospec.maxlambda := samplespectrum.MaxLambda
      else ratiospec.maxlambda := referencespectrum.MaxLambda;
    if ((ratiospec.Maxlambda - ratiospec.minlambda)<2) then
      begin
        showmessage('Overlapping wavelength range of sample and reference < 2 nm.  No computation of transmission or absorption spectrum.');
      end
     else
       begin
         scratchint1 := 0;
         scratchint2 := 0;
         for i := 0 to Length(samplespectrum.Wavelength)-1 do
             if (samplespectrum.Wavelength[i]>=ratiospec.minlambda) and (samplespectrum.Wavelength[i]<=ratiospec.maxlambda) then
                scratchint1 := scratchint1+1;
         for i := 0 to Length(referencespectrum.Wavelength)-1 do
             if (referencespectrum.Wavelength[i]>=ratiospec.minlambda) and (referencespectrum.Wavelength[i]<=ratiospec.maxlambda) then
                scratchint2 := scratchint2+1;
         i := 0;
         foundblock := false;
         if scratchint1>scratchint2 then
           begin
             ratiospec.numlambda := scratchint2;
             dominantspec := samplespec ;
             {set min and max pixels for spectrum}
             repeat
               if ABS(samplespectrum.wavelength[i]-samplespectrum.MinLambda)<0.01 then
                    begin
                      ifirst := i;
                      ilast := ratiospec.numlambda + i - 1;
                      foundblock := true;
                    end
                  else
                    begin
                      i := i+1;
                    end;
             until foundblock OR (samplespectrum.wavelength[i]-samplespectrum.MinLambda>0.02);
           end
          else if scratchint2>scratchint1 then
             begin
               ratiospec.numlambda := scratchint1;
               dominantspec := referencespec;
             {set min and max pixels for spectrum}
             repeat
               if ABS(referencespectrum.wavelength[i]-referencespectrum.MinLambda)<0.01 then
                    begin
                      ifirst := i;
                      ilast := ratiospec.numlambda + i - 1;
                      foundblock := true;
                    end
                  else
                    begin
                      i := i+1;
                    end;
             until foundblock OR (referencespectrum.wavelength[i]-referencespectrum.MinLambda>0.02);
             end
           else
             begin
               Ratiospec.numlambda := scratchint1;
               dominantspec := either;
             {set min and max pixels for spectrum}
               repeat
                 if ABS(referencespectrum.wavelength[i]-referencespectrum.MinLambda)<0.01 then
                    begin
                      ifirst := i;
                      ilast := ratiospec.numlambda + i - 1;
                      foundblock := true;
                    end
                  else
                    begin
                      i := i+1;
                    end;
               until foundblock OR (referencespectrum.wavelength[i]-referencespectrum.MinLambda>0.02);
             end  ;
           {if foundblock do the following; not yet revised in light of fixes above}
           if foundblock then
             begin
           case dominantspec of
             samplespec: begin
               k := 0;
               while (samplespectrum.Wavelength[k]-referencespectrum.Wavelength[ifirst])<0 do
                  k := k+1;
               for j := ifirst to ilast do
                  begin
                    if (samplespectrum.Wavelength[k]-referencespectrum.Wavelength[j])<0 then  {6/14/2011: replace referencespectrum.Wavelength[ifirst] with referencespectrum.Wavelength[j]}
                       while (samplespectrum.Wavelength[k]-referencespectrum.Wavelength[j])<0 do
                          k := k+1;
                    if referencespectrum.totalintense[j]<1E-50 then
                      referencespectrum.totalintense[j]:= 0.01; {concern: will this work with non-US character set machines?  Hope the number is set at compile time.}
                    if (samplespectrum.Wavelength[k]-samplespectrum.wavelength[k-1]=0) then
                       showmessage('Two adjacent sample spectrum wavelengths are identical.');
                    If (abs(samplespectrum.Wavelength[k]-referencespectrum.wavelength[j])<0.01) then
                      ratiospec.trans[j-ifirst] := samplespectrum.totalintense[k]/referencespectrum.totalintense[i] else
                      ratiospec.trans[j-ifirst] := (samplespectrum.totalintense[k-1] +
                      (samplespectrum.totalintense[k]-samplespectrum.totalintense[k-1])
                      *(referencespectrum.wavelength[j]-samplespectrum.wavelength[k-1])/
                      (samplespectrum.wavelength[k]-samplespectrum.wavelength[k-1]))/referencespectrum.totalintense[j];
                    ratiospec.wavelength[j-ifirst] := referencespectrum.Wavelength[j];
                    if ratiospec.trans[j-ifirst]>0 then ratiospec.abs[j-ifirst] := -ln(ratiospec.trans[j-ifirst])/ln(10)
                      else ratiospec.abs[j-ifirst] := -0.12345;
                  end;
               end;
             referencespec:  begin
               k := 0;
               while (referencespectrum.Wavelength[k]-samplespectrum.Wavelength[ifirst])<0 do
                  k := k+1;
               for j := ifirst to ilast do
                  begin
                    if (referencespectrum.Wavelength[k]-samplespectrum.Wavelength[j])<0 then   {6/14/2011: replace samplespectrum.Wavelength[ifirst] with samplespectrum.Wavelength[j]}
                       while (referencespectrum.Wavelength[k]-samplespectrum.Wavelength[j])<0 do
                          k := k+1;
                    If (abs(referencespectrum.Wavelength[k]-samplespectrum.wavelength[j])<0.01) then
                      ratiospec.trans[j-ifirst] := samplespectrum.totalintense[j]/referencespectrum.totalintense[k] else
                      ratiospec.trans[j-ifirst] := samplespectrum.totalintense[j]/(referencespectrum.totalintense[k-1]
                      +(referencespectrum.totalintense[k]-referencespectrum.totalintense[k-1]) * (samplespectrum.wavelength[j]-referencespectrum.wavelength[k-1])/
                      (referencespectrum.wavelength[k]-referencespectrum.wavelength[k-1]));
                    ratiospec.wavelength[j-ifirst] := samplespectrum.Wavelength[j];
                    if ratiospec.trans[j-ifirst]>0 then ratiospec.abs[j-ifirst] := -ln(ratiospec.trans[j-ifirst])/ln(10)
                      else ratiospec.abs[j-ifirst] := -0.12345;
                  end;
               end;
             either:  begin
                 for j := ifirst to ilast do
                   begin
                      ratiospec.wavelength[j-ifirst] := samplespectrum.wavelength[j];    {bug!! start at minlambda, not j=0!}
                      IF referencespectrum.totalintense[j]>0 then
                        ratiospec.trans[j-ifirst] := samplespectrum.totalintense[j]/referencespectrum.totalintense[j]
                        else ratiospec.trans[j-ifirst] := 2.00;
                      if ratiospec.trans[j-ifirst]>0 then ratiospec.abs[j-ifirst] := -ln(ratiospec.trans[j-ifirst])/ln(10)
                        else ratiospec.abs[j-ifirst] := -0.12345;
                   end;
                 end;
           end;
             end
           else
               showmessage('Inconsistent spectral data; could not compute transmittance or absorbance.');
       end;
end;

procedure TForm1.Button1Click(Sender: TObject);

var
  i, scratchint1, scratchint2 : integer;
  specdirec : integer; {2 means illegal}
  scratchreal1, scratchreal2 : real;
  SkipPlot : boolean;
{Plot Spectral Data}
begin
  SkipPlot := false;
  IF radiogroup1.itemindex <>2 then SpecAlignReconcile(sample);
  if radiogroup1.itemindex <>1 then SpecAlignReconcile(reference);
    {1) extract pixels and make intensity arrays as f(pixel)
     2) if warranted, intensity as f(wavelength)
     3) if warranted, compute T
     4) if warranted, compute A}
//  If pic1loaded then  RawToSpec(scratchpicture1, @SampleSpectrum, sample);
//  If pic2loaded then  RawToSpec(scratchpicture2, @ReferenceSpectrum, reference);
  If pic1loaded then  samplespectrum.RawToSpec2(scratchpicture1, sample);
  If pic2loaded then  referencespectrum.RawToSpec2(scratchpicture2, reference);
  if pic1loaded and pic2loaded and (radiogroup1.ItemIndex>2) then MakeTandA;
  case Radiogroup2.ItemIndex of {Label x axis}
     0 : begin  {Abscissa = pixel number}
       chart1.axes.bottom.Title.Caption := 'Pixel';
       scratchint1 := 10000;
       scratchint2 := 0;
       With referencespectrum do
         begin
           begin
             if (xmaxpixel=xminpixel) and (ymaxpixel=yminpixel) then
               specDirec := 2
               else SpecDirec := 1;
           end;
         end;
       if specDirec<>2 then
         if (samplespectrum.xmaxpixel = samplespectrum.xminpixel) and
            (samplespectrum.ymaxpixel = samplespectrum.yminpixel) then
             specDirec := 2;
       case Specdirec of
         1 : begin
              scratchreal1 := pythag(samplespectrum.xminpixel,samplespectrum.yminpixel, samplespectrum.xmaxpixel, samplespectrum.ymaxpixel);
              scratchint1 := round(scratchreal1);  // gratuitous sqrt removed 1/6/26. How did that fluke survive so long?
              scratchreal1 := pythag(referencespectrum.xminpixel,referencespectrum.yminpixel, referencespectrum.xmaxpixel, referencespectrum.ymaxpixel);
              scratchint2 := round(scratchreal1);  // same here!
              IF scratchint1>scratchint2 then scratchint2 := scratchint1;
              scratchint1 := 0;
           end;
         2 : begin
             showmessage('Scale parameters must allow a finite range of pixels or wavelengths to be displayed.'
             +'  Please assign spectral range. Possible cause: missing image.');
             chart1.axes.bottom.Minimum := 0;
             chart1.axes.bottom.Maximum := 100;
             chart1.axes.bottom.Increment := 20;
             SkipPlot := true;
             chart1.axes.bottom.title.Visible := false;
           end;
         end;
       If specdirec<>2 then begin
         chart1.axes.bottom.Minimum := scratchint1;
         chart1.axes.bottom.maximum := scratchint2;
         chart1.axes.bottom.Increment := (scratchint2-scratchint1)/5;
       end;
       end;
     1 : begin   {Abscissa = wavelength}
       chart1.axes.bottom.Title.Caption := 'Wavelength (nm)';
       scratchreal1 := referencespectrum.MinLambda;
       scratchreal2 := referencespectrum.MaxLambda;
       if samplespectrum.MinLambda<scratchreal1 then scratchreal1 := samplespectrum.MinLambda;
       if samplespectrum.maxlambda>scratchreal2 then scratchreal2 := samplespectrum.maxlambda;
       if ABS(scratchreal1 - scratchreal2)<0.1 then
         begin
           showmessage('Maximum and minimum wavelengths must be different.');
           skipplot := true;
         end
       else
         begin
           chart1.axes.bottom.Minimum := scratchreal1;
           chart1.axes.bottom.maximum := scratchreal2;
           chart1.axes.bottom.increment := (scratchreal2-scratchreal1)/5
         end;
     end;
  end;
  if ((Radiogroup1.ItemIndex>1) and not pic2loaded) or
     ((Radiogroup1.ItemIndex<>2) and not pic1loaded) then skipplot := true;
  if not skipplot then
    begin
    chart1.axes.bottom.Title.visible := true;
    if radiogroup1.itemindex<3 then
      begin
        scratchreal1 := 0;
        for i  := 0 to samplespectrum.numlambda-1 do
           if samplespectrum.totalintense[i]>scratchreal1 then scratchreal1 := samplespectrum.totalintense[i];
        for i := 0 to referencespectrum.numlambda - 1 do
           if referencespectrum.totalintense[i]>scratchreal1 then scratchreal1 := referencespectrum.totalintense[i];
        scratchreal2 := round(exp(round(ln(scratchreal1)+0.5)));
        chart1.axes.left.maximum := scratchreal2;
      end;
    For i := 0 to 7 do
      IF chart1.series[i].count>0 then chart1.series[i].clear;
    {set channel labels}
    chart1.Legend.Visible := true;
    chart1.legend.CustomPosition := true;
    chart1.legend.PositionUnits := muPercent;
    chart1.legend.TopPercent := 10; // tweak as needed
    chart1.legend.LeftPercent := 60; // tweak as needed
    chart1.series[0].legend.Visible := true;
    case radiogroup1.itemindex of
      0 : begin
        chart1.series[0].Title := 'Sample Red I';
        chart1.series[1].Title := 'Sample Green I';
        chart1.series[2].Title := 'Sample Blue I';
        chart1.series[3].Title := 'Sample Intensity';
        for i := 0 to 3 do
          begin
            chart1.series[i].Visible := true;
            chart1.series[i].Legend.Visible := true;
            chart1.series[i+4].visible := false;
            chart1.series[i+4].Legend.Visible := false;
          end;
      end;
      1 : begin
        chart1.series[4].Title := 'Reference Red I';
        chart1.series[5].Title := 'Reference Green I';
        chart1.series[6].Title := 'Reference Blue I';
        chart1.series[7].Title := 'Reference Intensity';
        for i := 4 to 7 do
          begin
            chart1.series[i].Visible := true;
            chart1.series[i].Legend.Visible := true;
            chart1.series[i-4].visible := false;
            chart1.series[i-4].Legend.visible := false;
          end;
      end;
      2 : begin
        chart1.series[0].Title := 'Sample Red I';
        chart1.series[1].Title := 'Sample Green I';
        chart1.series[2].Title := 'Sample Blue i';
        chart1.series[3].Title := 'Sample Total Intensity';
        chart1.series[4].Title := 'Reference Red I';
        chart1.series[5].Title := 'Reference Green I';
        chart1.series[6].Title := 'Reference Blue i';
        chart1.series[7].Title := 'Reference Total Intensity';
        for i := 0 to 7 do
          begin
            chart1.series[i].Visible := true;
            chart1.series[i].legend.Visible := true;
          end;
      end;
      3 : begin
        chart1.axes.left.title.Caption := 'Transmittance';
        chart1.series[0].Visible := true;
        chart1.series[0].legend.Visible := false;
        chart1.axes.left.Minimum := 0;
        chart1.axes.left.maximum := 1.0;
        chart1.axes.left.Increment := 0.2;
        for i := 1 to 7 do
           begin
             chart1.series[i].Visible := false;
             chart1.series[i].Legend.visible := false;
           end;
        chart1.Legend.Visible := false;
      end;
      4 : begin
        chart1.axes.left.Title.Caption := 'Absorbance';
        chart1.series[0].Visible := true;
        chart1.series[0].Legend.visible := false;
        chart1.axes.left.Minimum := 0;
        chart1.axes.left.maximum := 2;
        for i := 1 to 7 do
           begin
             chart1.series[i].Visible := false;
             chart1.series[i].Legend.Visible := false;
           end;
        chart1.Legend.Visible := false;
      end;
    end;
    case Radiogroup1.Itemindex of {Label y axis}
     0, 1, 2 : begin  {Raw intensity}
       chart1.axes.left.Title.Caption := 'Intensity';
     end;
     3 : begin  {Transmittance}
       chart1.axes.left.Title.caption := 'Transmittance';
     end;
     4 : begin  {Absorbance}
       chart1.axes.left.Title.caption := 'Absorbance';
     end;
    end;
    chart1.axes.left.Title.Visible := true;
    {Insert actually plotting here.  All x,y vectors empty}
     case radiogroup1.itemindex of
     0 :   begin {sample intensity}
             for i := 0 to samplespectrum.numlambda-1 do
               begin
                 if radiogroup2.itemindex=0 then
                    begin
                       scratchreal1 := i;
                       chart1.series[0].AddXY(double(scratchreal1),double(samplespectrum.redintense[i]));
                       chart1.series[1].AddXY(double(scratchreal1),double(samplespectrum.greenintense[i]));
                       chart1.series[2].AddXY(double(scratchreal1),double(samplespectrum.blueintense[i]));
                       chart1.series[3].AddXY(double(scratchreal1),double(samplespectrum.totalintense[i]));
                    end
                 else
                    begin
                       chart1.series[0].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.redintense[i]));
                       chart1.series[1].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.greenintense[i]));
                       chart1.series[2].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.blueintense[i]));
                       chart1.series[3].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.totalintense[i]));
                    end;
               end;
           end;
     1 :   begin {reference intensity}
             for i := 0 to referencespectrum.numlambda-1 do
               begin
                 if radiogroup2.itemindex=0 then
                    begin
                       scratchreal1 := i;
                       chart1.series[4].AddXY(double(scratchreal1),double(referencespectrum.redintense[i]));
                       chart1.series[5].AddXY(double(scratchreal1),double(referencespectrum.greenintense[i]));
                       chart1.series[6].AddXY(double(scratchreal1),double(referencespectrum.blueintense[i]));
                       chart1.series[7].AddXY(double(scratchreal1),double(referencespectrum.totalintense[i]));
                    end
                  else
                    begin
                       chart1.series[4].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.redintense[i]));
                       chart1.series[5].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.greenintense[i]));
                       chart1.series[6].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.blueintense[i]));
                       chart1.series[7].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.totalintense[i]));
                    end;
               end;
           end;
     2 :   begin {both}
             for i := 0 to samplespectrum.numlambda-1 do
               begin
                 if radiogroup2.itemindex=0 then
                    begin
                       scratchreal1 := i;
                       chart1.series[0].AddXY(double(scratchreal1),double(samplespectrum.redintense[i]));
                       chart1.series[1].AddXY(double(scratchreal1),double(samplespectrum.greenintense[i]));
                       chart1.series[2].AddXY(double(scratchreal1),double(samplespectrum.blueintense[i]));
                       chart1.series[3].AddXY(double(scratchreal1),double(samplespectrum.totalintense[i]));
                    end
                 else
                    begin
                       chart1.series[0].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.redintense[i]));
                       chart1.series[1].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.greenintense[i]));
                       chart1.series[2].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.blueintense[i]));
                       chart1.series[3].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.totalintense[i]));
                    end;
               end;
             for i := 0 to referencespectrum.numlambda-1 do
               begin
                 if radiogroup2.itemindex=0 then
                    begin
                       scratchreal1 := i;
                       chart1.series[4].AddXY(double(scratchreal1),double(referencespectrum.redintense[i]));
                       chart1.series[5].AddXY(double(scratchreal1),double(referencespectrum.greenintense[i]));
                       chart1.series[6].AddXY(double(scratchreal1),double(referencespectrum.blueintense[i]));
                       chart1.series[7].AddXY(double(scratchreal1),double(referencespectrum.totalintense[i]));
                    end
                 else
                    begin
                       chart1.series[4].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.redintense[i]));
                       chart1.series[5].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.greenintense[i]));
                       chart1.series[6].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.blueintense[i]));
                       chart1.series[7].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.totalintense[i]));
                    end;
               end;
           end;
     3 :   begin {Transmittance}
             for i := 0 to ratiospec.numlambda-1 do
                begin
                   chart1.series[0].AddXY(double(ratiospec.wavelength[i]),ratiospec.trans[i]);
                end;
           end;
     4 :   begin {Absorbance}
             for i := 0 to ratiospec.numlambda-1 do
                begin
                   chart1.series[0].AddXY(double(ratiospec.wavelength[i]),ratiospec.abs[i]);
                end;
           end;
     end;
    end;
end;

procedure TForm1.Button2Click(Sender: TObject);

{Export data to .TXT file}

var
  i, maxpts : integer;
  CSVOutput :  textfile;
  SepSymbol : char;

begin
  SaveTextFileDialog1.DefaultExt := 'TXT';
  SaveTextFileDialog1.FileName := myfilenamecache;
  SepSymbol := char(9); {tab delimiter}
  IF SaveTextFileDialog1.Execute then
    begin
      {$I-}
      Assignfile(CSVoutput, savetextfiledialog1.FileName);
      Myfilenamecache := savetextfiledialog1.filename;
      Reset(CSVoutput);
      if Ioresult<>0 then
        rewrite(CSVoutput) else
        begin
          append(CSVoutput);
          showmessage('Appending new data to pre-existing file.');
        end;
      {$I+}
      {if exists, append, otherwise reset}
  {Output header information: file names, extraction parameters
   List column 1-2 = pixel number and wavelength, sample
   Column 3-6 = I(red), I(green), I(blue), I(total)
   column 7-8 = pixel number and wavelength, reference
   column 9-12 = I(red), I(green), I(blue), I(total)
   Column 13-15 = wavelength, T, and A
   Any missing data show as "MD"}
       maxpts := samplespectrum.numlambda;
       if referencespectrum.numlambda>samplespectrum.numlambda then
          maxpts := referencespectrum.numlambda;
       Write(CSVoutput,'pixel number', SepSymbol, 'wavelength', SepSymbol, 'Isample(red)', SepSymbol, 'Isample(green)', SepSymbol, 'Isample(blue)', SepSymbol, 'Isample(total)',SepSymbol);
       Write(CSVoutput,'pixel number', SepSymbol, 'wavelength, Iref(red)', SepSymbol, 'Iref(green)', SepSymbol, 'Iref(blue)', SepSymbol, 'Iref(total)', SepSymbol);
       Writeln(CSVoutput, 'wavelength', SepSymbol, 'Transmittance', SepSymbol, 'Absorbance');
       for i := 0 to maxpts do
           begin
             if i<samplespectrum.numlambda then
               begin
                 Write(CSVoutput,InttoStr(i),SepSymbol,FloattoStr(samplespectrum.Wavelength[i]),SepSymbol,
                   floattoStr(samplespectrum.redintense[i]),SepSymbol,floattoStr(samplespectrum.greenintense[i]),SepSymbol,
                   floattoStr(samplespectrum.blueintense[i]),SepSymbol,floattoStr(samplespectrum.totalintense[i]),SepSymbol,' ');
               end
             else
               begin
                 Write(CSVoutput,' ',SepSymbol,' ',SepSymbol,' ',SepSymbol,' ',SepSymbol,' ',SepSymbol,' ',SepSymbol,' ');
               end;
             if i<referencespectrum.numlambda then
               begin
                 Write(CSVoutput,InttoStr(i),SepSymbol,FloattoStr(referencespectrum.Wavelength[i]),SepSymbol,
                   floattoStr(referencespectrum.redintense[i]),SepSymbol,floattoStr(referencespectrum.greenintense[i]),SepSymbol,
                   floattoStr(referencespectrum.blueintense[i]),SepSymbol,floattoStr(referencespectrum.totalintense[i]),SepSymbol,' ');
               end
             else
               begin
                 Write(CSVoutput,' ',SepSymbol,' ',SepSymbol,' ',SepSymbol,' ',SepSymbol,' ',SepSymbol,' ',SepSymbol,' ');
               end;
             if i<ratiospec.numlambda then
               begin
                 Writeln(CSVoutput, floattostr(ratiospec.wavelength[i]),SepSymbol, floattostr(ratiospec.trans[i]),SepSymbol,
                   floattostr(ratiospec.abs[i]));
               end
             else
               begin
                 Writeln(CSVoutput,' ',SepSymbol,' ',SepSymbol,' ');
               end;
           end;
       Flush(CSVoutput);
       Closefile(CSVOutput);
       ShowMessage('TXT tab-delimited output data reflect most recent plot.');
    end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  application.Terminate;
end;

procedure TForm1.Button3MouseEnter(Sender: TObject);
begin
  ShowHint:=true;
end;

procedure TForm1.Button3MouseLeave(Sender: TObject);
begin
  ShowHint := false;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  charteditor1.Chart := chart1;
  charteditor1.Execute;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);

var
  ii : integer;
  atleastonechecked : boolean;
  buildstring : string;

begin
  atleastonechecked := false;
  for ii := 0 to 2 do
     if checkboxlist[ii].Checked then
       atleastonechecked := true;
  if atleastonechecked then
    begin
      buildstring := '';
      if checkboxlist[0].checked then
        begin
          buildstring := buildstring + 'BMP files (*.BMP)|*.BMP;*.bmp';
        end;
      if checkboxlist[1].checked then
        begin
          if length(buildstring)>0 then
            buildstring := buildstring + ';';
          buildstring := buildstring + 'JPG files (*.JPG)|*.JPG;*.jpg';
        end;
      if checkboxlist[2].checked then
        begin
          if length(buildstring)>0 then
            buildstring := buildstring +' ;';
          buildstring := buildstring + 'PNG files (*.PNG)|*.PNG;*.png';
        end;
    end
  else
    begin
      showmessage('At least one file type must be enabled. Defaulting to JPG.');
      if sender = checkbox2 then checkbox2.setfocus else
        begin
          checkbox2.checked := true;
          buildstring := 'JPG files (*.JPG)|*.JPG;*.jpg';
        end;
    end;
  dataopendialog1.filter := buildstring;
  FileListbox1.Mask :=  dataopendialog1.filter;
  FileListbox2.Mask :=  dataopendialog1.filter;
end;


procedure TForm1.DirectoryListBox1DblClick(Sender: TObject);
begin
//  Opendialog1.Filter := 'JPeg Files (*.JPG) | *.JPG';
  If dataOpenDialog1.Execute then
    begin
      OpenFile(dataOpenDialog1.filename, Sample);
      Samplespectrum.filename := dataOpenDialog1.filename;
    end;
end;

procedure TForm1.DirectoryListBox2DblClick(Sender: TObject);
begin
//  Opendialog1.Filter := 'JPeg Files (*.JPG) | *.JPG';
  If dataOpenDialog1.Execute then
    begin
      OpenFile(dataOpendialog1.filename, Reference);
      Referencespectrum.filename := dataOpendialog1.filename;
    end;
end;

procedure TForm1.Edit10Exit(Sender: TObject);
var
 tempintvar : integer;
begin
  {check validity and, if OK, update field}
  tempintvar := 0;
  if valintrange(Sender, referenceSpectrum.yminpixel, tempintvar, Image2.Height) then
    formanimage(reference)
  else
    Edit10.SetFocus;
end;

procedure TForm1.Edit11Exit(Sender: TObject);
var
  temprealvar1, temprealvar2 : real;
begin
  {check validity and, if OK, update field}
  temprealvar1 := strtofloat(Edit8.text,cpsformatsettings)+1;
  temprealvar2 := 999.9;
  IF ValfloatRange(Sender, ReferenceSpectrum.MaxLambda, temprealvar1, temprealvar2) then
     formanimage(reference)
  else
    begin
      Edit11.SetFocus;
    end;
end;

procedure TForm1.Edit12Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, referenceSpectrum.xmaxpixel, 0, Image2.Width) then
    formanimage(reference)
  else
    Edit12.SetFocus;
end;

procedure TForm1.Edit13Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, referenceSpectrum.ymaxpixel, 0, Image2.Height) then
    formanimage(reference)
  else
    Edit13.SetFocus;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  IF ValfloatRange(Sender, SampleSpectrum.MinLambda, 200.0, strtofloat(Edit4.text,CPSFormatSettings)-1) then
     formanimage(sample)
  else
    begin
      Edit1.SetFocus;
    end;
end;

procedure TForm1.Edit2Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.xminpixel, 0, Image1.Width) then
    formanimage(sample)
  else
    Edit2.SetFocus;
end;

procedure TForm1.Edit3Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.yminpixel, 0, Image1.Height) then
    formanimage(sample)
  else
    Edit3.SetFocus;
end;

procedure TForm1.Edit4Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  IF ValfloatRange(Sender, SampleSpectrum.MaxLambda, strtofloat(Edit1.text,CPSFormatSettings)+1, 999.9) then
     formanimage(sample)
  else
    begin
      Edit4.SetFocus;
    end;
end;

procedure TForm1.Edit5Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.xmaxpixel, 0, Image1.Width) then
    formanimage(sample)
  else
    Edit5.SetFocus;
end;

procedure TForm1.Edit6Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.ymaxpixel, 0, Image1.Height) then
    formanimage(sample)
  else
    Edit6.SetFocus;
end;

procedure TForm1.Edit7Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.pixheight, 1, 99) then  // should max height be 99 pixels or image height/4?
    begin
      ReferenceSpectrum.pixheight := STRtoINT(Edit7.text) ;
      SampleSpectrum.pixheight := ReferenceSpectrum.pixheight;
      formanimage(sample);
      formanimage(reference);
    end
  else
    Edit7.SetFocus;
end;

procedure TForm1.Edit8Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  IF ValfloatRange(Sender, ReferenceSpectrum.MinLambda, 200.0, strtofloat(Edit11.text,CPSFormatSettings)-1) then
     formanimage(reference)
  else
    begin
      Edit8.SetFocus;
    end;
end;

procedure TForm1.Edit9Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, referenceSpectrum.xminpixel, 0, Image2.Width) then
    formanimage(reference)
  else
    Edit9.SetFocus;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
  Application.Terminate;
end;

procedure TForm1.FileListBox1DblClick(Sender: TObject);
begin
  OpenFile(FileListbox1.Filename, Sample); {need to send filename to OpenFile}
  Samplespectrum.filename := FileListbox1.Filename;
end;

procedure TForm1.FileListBox2DblClick(Sender: TObject);
begin
  OpenFile(FileListbox2.Filename, Reference);
  Referencespectrum.filename := FileListbox2.Filename;
end;

procedure TForm1.LoadReferenceRight1Click(Sender: TObject);
begin
//  Opendialog1.Filter := 'JPeg Files (*.JPG) | *.JPG';
  If dataOpenDialog1.Execute then
    begin
      Openfile(dataOpendialog1.FileName, Reference);
      Referencespectrum.filename := dataOpendialog1.FileName;
    end;
end;

procedure TForm1.LoadSampleLeft1Click(Sender: TObject);
begin
//  Opendialog1.Filter := 'JPeg Files (*.JPG) | *.JPG';
  If dataOpenDialog1.Execute then
    begin
      Openfile(dataOpendialog1.Filename, Sample);
      samplespectrum.filename := dataOpendialog1.Filename;
    end;
end;

procedure Tform1.ImageMouseClick(ActiveImage : TImage; SpectralData : PSpectrum; whichone : TSpecImData) ;

Var
  localclicktype : TSpecButVal ;
  Mouselocale, ScrollMove : Tpoint;
  BitMapImage : Tbitmap;
  TempModal : TModalresult;

begin
   {initial origin is upper left corner of screen}
   GetCursorPos(MouseLocale);
   {switch origin to scrollbox origin}
   Mouselocale := ScreenToClient(Mouselocale);
   case whichone of
     sample: begin
        scrollmove.x := scrollbox1.HorzScrollBar.scrollpos-scrollbox1.left;
        scrollmove.y := scrollbox1.VertScrollBar.scrollpos-scrollbox1.top;
        BitMapImage := Scratchpicture1;
      end;
     reference:  begin
          scrollmove.x := scrollbox2.HorzScrollBar.scrollpos-scrollbox2.left;
          scrollmove.y := scrollbox2.VertScrollBar.scrollpos-scrollbox2.top;
          BitMapImage := Scratchpicture2;
      end;
   end;
   {now convert mouse position to relative to canvas origin}
   Mouselocale.X := Mouselocale.X + scrollmove.x;
   Mouselocale.Y := Mouselocale.Y + scrollmove.y;
   Repeat TempModal:= Form3.showmodal until ((Tempmodal = mrCancel) or (Tempmodal = mrYes) or (Tempmodal = mrNo));
   localclicktype := Form3.whichbut;
   if localclicktype<>neither then
      begin
        {update edit and consequent fields}
        case localclicktype of
          blue : begin
            SpectralData^.xminpixel := Mouselocale.X;
            SpectralData^.yminpixel := Mouselocale.Y;
            SpectralData^.Specinputs[2]^.Text := InttoSTR(Mouselocale.X) ;
            SpectralData^.SpecInputs[3]^.Text := InttoSTR(Mouselocale.Y) ;
          end;
          red :  begin
            SpectralData^.xmaxpixel := Mouselocale.X;
            SpectralData^.ymaxpixel := Mouselocale.Y;
            SpectralData^.Specinputs[4]^.Text := InttoSTR(Mouselocale.X) ;
            SpectralData^.SpecInputs[5]^.Text := InttoSTR(Mouselocale.Y) ;
          end;
        end;
        {call drawing routine}
        DrawSpecGuide(BitMapImage, ActiveImage, SpectralData);
      end;
end;

procedure TForm1.Print1Click(Sender: TObject);
var
  AspectRatio: Single;
  OutputWidth, OutputHeight : Single;
begin
  if PrintDialog1.Execute then
    begin
      Printer.BeginDoc;
      Try
        {fill in later if at all}
        ShowMessage('Printing numbers not coded.'+
                CHR(13)+'Click the "Generate Tab-delimited TXT" button to send data to a spreadsheet.'+
                CHR(13)+'To print the plot, use the print function in the chart editor.');
      Finally
        Printer.EndDoc;
      End;
    end;
end;

procedure TForm1.PrintSetup1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TForm1.Openfile(const filename:string; Whichone: TSpecImData);

var
//  tempimageJ : TJPegImage;
//  tempimageP : TPNGImage;
//  tempimageB : TBitmap;
  temppicture : tpicture;
//  mytemp : boolean;

// FIX HERE add input of other file types
// try
{Picture.LoadFromFile('C:\imagedata.dat');
    Bitmap := TBitmap.Create;
    try
      Bitmap.Width := Picture.Width;
      Bitmap.Height := Picture.Height;
      Bitmap.Canvas.Draw(0, 0, Picture.Graphic);}

begin
  temppicture := tpicture.create;
  try
    try
      temppicture.LoadFromFile(filename);
      case whichone of
        sample : begin
          if not assigned(image1.picture.bitmap) then
            begin
              image1.picture.bitmap := tbitmap.create;
              image1.picture.bitmap.PixelFormat := pf32bit;   // allows RGBQuad
            end;
          image1.picture.bitmap.width := temppicture.width;
          image1.width := temppicture.Width;
          image1.picture.bitmap.height := temppicture.height;
          image1.height := temppicture.height;
          image1.picture.bitmap.canvas.draw(0,0,temppicture.graphic);
          pic1loaded := true;
        end;
        reference: begin
          if not assigned(image2.picture.bitmap) then
            begin
              image2.picture.bitmap := tbitmap.create;
              image2.picture.bitmap.PixelFormat := pf32bit;  // forces RGBQuad as default
            end;
          image2.picture.bitmap.width := temppicture.width;
          image2.width := temppicture.Width;
          image2.picture.bitmap.height := temppicture.height;
          image2.height := temppicture.height;
          image2.picture.bitmap.canvas.draw(0,0,temppicture.graphic);
          pic2loaded := true;
        end;
      end;
  except
    on einvalidgraphic do
      begin
        ShowMessage('When is a graphic file not a graphic file?');
        case whichone of
          sample: Pic1Loaded := false;
          reference: Pic2Loaded := false;
        end;
        exit;
      end;
    end;
  finally
    temppicture.destroy;
    if pic1loaded and pic2loaded then
      begin
        label22.visible := false;
        radiogroup1.visible := true;
        radiogroup2.visible := true;
        button1.visible := true;
        button2.visible := true;
      end
    else
      begin
        if pic1loaded then
          label22.caption := 'Load Reference Image'
        else
          label22.caption := 'Load Sample Image';
      end;
  end;
  if (whichone=sample) and pic1loaded then
    begin
      image1.picture.bitmap.canvas.pen.color := clblack;
      image1.picture.bitmap.canvas.moveto(0,0);
      image1.picture.bitmap.canvas.LineTo(0,1);
      ScratchPicture1.Assign(Image1.Picture.Bitmap);
      SampleSpectrum.Speccurrent := false;
      FormAnImage(Whichone) ; // make Image1 with overlay
      button1.Enabled := true;
      button2.Enabled := true;
      image1.update;
    end;
  if (whichone=reference) and pic2loaded then
    begin
      image2.picture.bitmap.canvas.pen.color := clblack;
      image2.picture.bitmap.canvas.moveto(0,0);
      image2.picture.bitmap.canvas.LineTo(0,1);
      ScratchPicture2.Assign(Image2.Picture.Bitmap);
      ReferenceSpectrum.Speccurrent := false;
      FormAnImage(Whichone) ; // make Image2 with overlay
      button1.Enabled := true;
      button2.Enabled := true;
      image2.update;
    end;
end;


procedure TForm1.DrawSpecGuide(UnMarkedPicture : Tbitmap; DestIm : TImage; SpectralData : PSpectrum);

const
  RectSizeSpec = 4; {half size of square box}

begin
  SpectralData.Speccurrent := false;
  DestIm.Canvas.Draw(0,0,UnMarkedPicture);
  {ensure drawing is legal}
  if (SpectralData.xmaxpixel<=UnmarkedPicture.width) and (SpectralData.ymaxpixel<=UnmarkedPicture.height) then
    begin
  {draw red and blue boxes}
      DestIm.Canvas.Brush.style := bsclear;
      DestIm.Canvas.Pen.Color := clRed;
      DestIm.Canvas.Rectangle(SpectralData.xmaxpixel-RectSizeSpec,SpectralData.ymaxpixel-RectSizeSpec,
        SpectralData.xmaxpixel+RectSizeSpec,SpectralData.ymaxpixel+RectSizeSpec);
      DestIm.Canvas.Pen.Color := clBlue;
      DestIm.Canvas.Rectangle(SpectralData.xminpixel-RectSizeSpec,SpectralData.yminpixel-RectSizeSpec,
        SpectralData.xminpixel+RectSizeSpec,SpectralData.yminpixel+RectSizeSpec);
  {draw line between boxes}
      DestIm.Canvas.Pen.color := clLime;
      DestIm.Canvas.MoveTo(SpectralData.xminpixel,SpectralData.yminpixel);
      DestIm.Canvas.LineTo(SpectralData.xmaxpixel,SpectralData.ymaxpixel);
      if SpectralData.pixheight>4 then
         begin
           {draw lines on either side of spec centerline}
           DestIm.Canvas.Pen.Color := clGreen;
           if (ABS(SpectralData.xmaxpixel-SpectralData.xminpixel)>
               ABS(SpectralData.ymaxpixel-SpectralData.yminpixel)) then
               begin
                 DestIm.Canvas.MoveTo(SpectralData.xminpixel,SpectralData.yminpixel-SpectralData.pixheight div 2);
                 DestIm.Canvas.LineTo(SpectralData.xmaxpixel,SpectralData.ymaxpixel-SpectralData.pixheight div 2);
                 DestIm.Canvas.MoveTo(SpectralData.xminpixel,SpectralData.yminpixel+SpectralData.pixheight div 2);
                 DestIm.Canvas.LineTo(SpectralData.xmaxpixel,SpectralData.ymaxpixel+SpectralData.pixheight div 2);
               end
           else
               begin
                 DestIm.Canvas.MoveTo(SpectralData.xminpixel-SpectralData.pixheight div 2,SpectralData.yminpixel);
                 DestIm.Canvas.LineTo(SpectralData.xmaxpixel-SpectralData.pixheight div 2,SpectralData.ymaxpixel);
                 DestIm.Canvas.MoveTo(SpectralData.xminpixel+SpectralData.pixheight div 2,SpectralData.yminpixel);
                 DestIm.Canvas.LineTo(SpectralData.xmaxpixel+SpectralData.pixheight div 2,SpectralData.ymaxpixel);
               end;
         end;
    end
  else  begin
    ShowMessage('Not showing spectrum location in image.  Current drawing parameters exceed image size.  Please retry setting spectrum location.');
  end;
  DestIm.Repaint;
end;

procedure Tform1.FormAnImage(whichone: TSpecImData);

begin
  case whichone of
    sample: begin
      SpecAlignReconcile(sample);
      if Pic1Loaded then
         DrawSpecGuide(scratchpicture1,Image1,@SampleSpectrum);
    end;
    reference: begin
      SpecAlignReconcile(reference);
      If Pic2Loaded then
         DrawSpecGuide(scratchpicture2,Image2,@ReferenceSpectrum);
    end;
  end;
end;

procedure Tform1.SpecAlignReconcile(whichone : TSpecImData);

begin
  case whichone of
     sample : begin
       With SampleSpectrum do
         begin
           MinLambda := STRtoFloat(SpecInputs[0]^.text,CPSFormatSettings);
           MaxLambda := STRtoFloat(SpecInputs[1]^.text,CPSFormatSettings);
           xminpixel := STRtoINT(edit2.text);
           yminpixel := STRtoINT(edit3.text);
           xmaxpixel := STRtoINT(edit5.text);
           ymaxpixel := STRtoINT(edit6.text);
           pixheight := STRtoINT(SpecInputs[6]^.text);
           {Set graphics, then regenerate plot}
         end;
     end;
     reference : begin
       With ReferenceSpectrum do
         begin
           MinLambda := STRtoFloat(SpecInputs[0]^.text,CPSFormatSettings);
           MaxLambda := STRtoFloat(SpecInputs[1]^.text,CPSFormatSettings);
           xminpixel := STRtoINT(edit9.text);
           yminpixel := STRtoINT(edit10.text);
           xmaxpixel := STRtoINT(edit12.text);
           ymaxpixel := STRtoINT(edit13.text);
           pixheight := STRtoINT(SpecInputs[6]^.text);
           {Set graphics, then regenerate plot}
         end;
     end;
  end;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  edit14.text := inttostr(trackbar1.Position);
  // need to link to plot
  chart1.Title.Font.Size := trackbar1.position;
  chart1.Legend.Font.size := trackbar1.position;
  chart1.axes.left.Texts.Font.size := trackbar1.position;
  chart1.axes.Bottom.texts.font.size := trackbar1.position;
  chart1.axes.left.Title.Font.size := trackbar1.position;
  chart1.axes.bottom.title.Font.size := trackbar1.position;
end;

procedure TForm1.UpDown1ChangingEx(Sender: TObject; var AllowChange: Boolean;
  NewValue: Smallint; Direction: TUpDownDirection);
// procedure TForm1.UpDown1ChangingEx(Sender: TObject; var AllowChange: Boolean;
//   NewValue: Smallint; Direction: TUpDownDirection);

begin
  ReferenceSpectrum.pixheight := STRtoINT(Edit7.text) ;
  SampleSpectrum.pixheight := ReferenceSpectrum.pixheight;
end;

function Tform1.ValIntRange(Sender: TObject; itarget, imin, imax: integer) : Boolean;

var
  TempInt : integer;
  localflag : tReplaceFlags;
begin
  localflag := [rfReplaceAll];
  Try
    Tempint := Strtoint(TEdit(Sender).text);
      if TempInt<imin then
        begin
          TempInt := imin;
          ShowMessage ('Entered value below allowed minimum of '+InttoSTR(imin)
          +'.  Setting to allowed minimum.');
        end
        else
          if TempInt>imax then
            begin
              TempInt := imax;
              ShowMessage ('Entered value above allowed maximum of '+InttoSTR(imax)
              +'.  Setting to allowed maximum.');
            end;
      TEdit(Sender).text := InttoSTR(TempInt);
{      itarget := TempInt;  }
      ValIntRange := true;
  except
    on e:econverterror do
    begin
      Showmessage('Input must be an integer between '+InttoSTR(imin)+' and '+InttoSTR(imax)+'.');
      ValIntRange := false;
    end;
  End;
end;

function Tform1.ValFloatRange(Sender: TObject; rtarget, rmin, rmax: real) : Boolean;

var
  TempReal : real;
//  errorcode : integer;
  localflag : tReplaceFlags;

begin
  localflag := [rfReplaceAll];
  Try
    Begin
      TempReal:=STRtoFloat(TEdit(Sender).text, CPSFormatSettings);
      if Tempreal<rmin then
        begin
          Tempreal := rmin;
          ShowMessage('Entered value below allowed minimum of '+FloattoSTRF(rmin,fffixed, 4,1,CPSFormatSettings)
          +'.  Setting to allowed minimum.');
        end
      else
       begin
         if Tempreal>rmax then
          begin
            Tempreal := rmax;
            ShowMessage('Entered value above allowed maximum of '+FloattoSTRF(rmax,fffixed, 4,1,CPSFormatSettings)
             +'.  Setting to allowed maximum.');
          end;
       end;
      rtarget := Tempreal;
      TEdit(Sender).text := FloattoSTRF(rtarget,fffixed, 4,1,CPSFormatSettings);
      ValFloatRange := true;
    End;
  except
    on e:econverterror do
      begin
      ShowMessage('Input must be a real number in the range '+ FloattoSTRF(rmin,fffixed, 4,1,CPSFormatSettings)
      + ' to '+FloattoSTRF(rmax,fffixed, 4,1)+'.  Please re-enter.');
      valFloatrange := false;
      end;
  End;
end;

{  case Whichone of
    sample: begin
            Try
              begin
                { ScratchPicture1.LoadFromFile(Filename);
                Image1.Picture.LoadFromFile(Filename);
              end;
            except
              on EInvalidGraphic do Image1.Picture.Graphic := nil;
            end;
              if (IMage1.Picture.Graphic <> nil) and (Image1.Picture.graphic is TJpegImage) then
                begin
                  tempimage := TJPegImage.create;
                  try
                    tempimage.assign(Image1.Picture.graphic);
                    Image1.picture.Bitmap.assign(tempimage);
                  finally
                    Freeandnil(tempimage);
                  end;
                  ScratchPicture1.Assign(Image1.Picture.Bitmap);
                  Pic1Loaded := true;
                  SampleSpectrum.Speccurrent := false;
                  FormAnImage(Whichone) ; {make Image1 with overlay
                  button1.Enabled := true;
                  button2.Enabled := true;
                end
                else
                  begin
                    ShowMessage('When is a JPG not a JPG?');
                    Pic1Loaded := false;
                  end;
           end;
    reference: begin
               Try
                 begin
                  {Scratchimage2.Picture.LoadFromFile(Filename);
                  Image2.Picture.LoadFromFile(Filename);
                 end;
               except
                 on EInvalidGraphic do Image2.Picture.Graphic := nil;
               end;
              if (IMage2.Picture.Graphic <> nil) and (Image2.Picture.graphic is TJpegImage) then
                begin
                  tempimage := TJPegImage.create;
                  try
                    tempimage.assign(Image2.Picture.graphic);
                    Image2.picture.Bitmap.assign(tempimage);
                  finally
                    Freeandnil(tempimage);
                  end;
                  ScratchPicture2.Assign(Image2.Picture.Bitmap);
                  Pic2Loaded := true;
                  FormAnImage(Whichone) ; {make Image1 with overlay
                  button1.Enabled := true;
                  button2.Enabled := true;
                  Referencespectrum.Speccurrent := false;
                end
                else
                  begin
                    ShowMessage('When is a JPG not a JPG?');
                    Pic2Loaded := false;
                  end;
    end;
  end;   }

{  if isline then
    begin
      if xisdominant then
        begin
          tanradians := tan(radians); // if y dominant, this could diverge
          for inx := colmin to colmax do
             begin
               inyoriginal := center.y + round(tanradians*(inx - colmin));
               originalrow := unmarkedpicture.ScanLine[inyoriginal];
               inxprimerotated := round(sqrt((inx-center.x)*(inx-center.x)+(inyoriginal-center.y)*(inyoriginal-center.y)));
{               if isntpf32 then  only deal with this if something wonky happens
                 begin

                 end
               else      }
{                 begin
                   redintense[inx-colmin] := redintense[inx-colmin] + originalrow[inxprimerotated].rgbtRed;
                   greenintense[inx-colmin] := greenintense[inx-colmin] + originalrow[inxprimerotated].rgbtgreen;
                   blueintense[inx-colmin] := blueintense[inx-colmin] + originalrow[inxprimerotated].rgbtblue;
                 end;
             end;
        end
      else
        begin
          for iny := rowmin to rowmax do
             tanradians := tan(radians-pi/2); // slope w.r.t. y axis
             intercept := round(center.x - tanradians*center.y);  // finds x axis intercept
             begin
               originalrow := unmarkedpicture.scanline[iny];
//               inxoriginal :=
             end;
        end;
    end
  else
    begin
      if xisdominant then
        begin
          for inY := rowmin to rowmax do
             begin
                // find min and max x values
                for inx := colmin to colmax do
                   begin
                     // find rotated x
                     // add to spectrum
                   end;
             end;
        end
      else
        begin
          for inY := rowmin to rowmax do
             begin
                // find min and max x values
                for inx := colmin to colmax do
                   begin
                     // find rotated x
                     // add to spectrum
                   end;
             end;
        end;
     end;     }
  // find total at each wavelength
          // delete below here
{      {, leftnum, rightnum, testitemp
       if boxcorners[1].x<boxcorners[2].x then // choose which side is on the left
            begin
              leftnum := 1;
              rightnum := 2;
            end
          else
            begin
              leftnum := 2;
              rightnum := 1;
            end;
          if boxcorners[leftnum].y<=yval then // are we above or at the left pivot?
            begin // follow [0] [leftnum] boundary
              if boxcorners[0].x=boxcorners[leftnum].x then
                result.x := boxcorners[0].X
              else
                begin
                  localslope := (boxcorners[leftnum].y-boxcorners[0].y)/(boxcorners[0].x-boxcorners[leftnum].x);
                  testitemp := max(0,round(boxcorners[0].x+ii*localslope));
                  result.x := testitemp;
                end;
            end
          else
            begin // follow [leftnum] [3] boundary
              if boxcorners[leftnum].x=boxcorners[3].x then
                result.x := boxcorners[leftnum].X
              else
                begin
                  localslope := (boxcorners[3].y-boxcorners[leftnum].y)/(boxcorners[leftnum].x-boxcorners[3].x);
                  testitemp := max(0,round(boxcorners[leftnum].x+(ii+(boxcorners[leftnum].y-boxcorners[3].y))*localslope));
                  result.x := testitemp;
                end;
            end;
          // find right limit
          if boxcorners[rightnum].y<=yval then
            begin // follow [0] [rightnum] boundary
              if boxcorners[0].x = boxcorners[rightnum].x then
                result.y := boxcorners[rightnum].X
              else
                begin
                  localslope := (boxcorners[rightnum].y-boxcorners[0].y)/(boxcorners[0].x-boxcorners[rightnum].x);
                  testitemp := max(result.x,min(boxcorners[rightnum].x+round(ii*localslope),unmarkedpicture.width));
                  result.y := testitemp;
                end;
            end
          else
            begin // follow [rightnum] [3] boundary
              if boxcorners[rightnum].x = boxcorners[3].x then
                result.y := boxcorners[rightnum].X
              else
                begin
                  localslope := (boxcorners[3].y-boxcorners[rightnum].y)/(boxcorners[rightnum].x-boxcorners[3].x);
                  testitemp := max(result.x,min(boxcorners[rightnum].x+round(ii+(boxcorners[rightnum].y-boxcorners[3].y)*localslope),unmarkedpicture.width));
                  result.y := testitemp;
                end;
            end;     }

end.
